<?php
declare(strict_types = 1);

/**
 * Artificial neural network for PHP
 *
 * @link https://ann.thwien.de/
 * @author Thomas Wien
 * @version 3.0
 * @copyright Copyright 2007-2025 by Thomas Wien
 * @license https://opensource.org/license/BSD-2-Clause BSD 2-Clause License
 */
namespace ANN;

/**
 *
 * @access private
 */
trait Maths
{

    /**
     *
     * @param float $floatValue
     * @return float (between near 0 and near 1)
     */
    public static function sigmoid(float $floatValue): float
    {
        return 1 / (1 + exp(- 1 * $floatValue));
    }

    /**
     *
     * @param float $floatValue
     * @return integer (0 or 1)
     */
    public static function threshold(float $floatValue): int
    {
        return ($floatValue > 0.5) ? 1 : 0;
    }

    /**
     *
     * @return float
     */
    public static function randomDelta(): float
    {
        return mt_rand(- 999, 999) / 1000;
    }

    /**
     *
     * @return float
     */
    public static function randomWeight(): float
    {
        return mt_rand(- 2000, 2000) / 1000;
    }
}
