<?php
declare(strict_types = 1);

/**
 * Artificial neural network for PHP
 *
 * @link https://ann.thwien.de/
 * @author Thomas Wien
 * @version 3.0
 * @copyright Copyright 2007-2025 by Thomas Wien
 * @license https://opensource.org/license/BSD-2-Clause BSD 2-Clause License
 */
namespace ANN;

class Loader
{

    /**
     *
     * @var string
     */
    protected string $strDir = '';

    public function __construct()
    {
        $this->checkPHPVersion();

        $this->strDir = dirname(__FILE__);

        spl_autoload_register(array(
            $this,
            'autoload'
        ));
    }

    public function __destruct()
    {
        spl_autoload_unregister(array(
            $this,
            'autoload'
        ));
    }

    /**
     *
     * @param string $strClassname
     * @return boolean
     */
    public function autoload(string $strClassname): bool
    {
        if (! preg_match('/^ANN\\\/', $strClassname))
            return FALSE;

        $strClassname = preg_replace('/^ANN\\\/', '', $strClassname);

        $strClassname = preg_replace('/\\\/', DIRECTORY_SEPARATOR, $strClassname);

        $strFilename = $this->strDir . "/$strClassname.php";

        if (is_file($strFilename))
        {
            require_once ($strFilename);

            return TRUE;
        }

        return FALSE;
    }

    protected function checkPHPVersion(): void
    {
        if (version_compare(PHP_VERSION, '8.2.0') < 0)
        {
            throw new \Exception('Use PHP version >= 8.2 for running ANN library');
        }
    }
}

$objANNLoader = new Loader();